/**
 * SkillDict SCORM Interface
 */

/* TODO: Amit kezelni kell
 * - Inicializálás a betöltést követően
 * Csak egyszer küldjük át az inicializálás során, majd a szerver oldalon ezzel dolgozunk tovább...:
 * - Felhasználó ID => átküldése (cmi.core.student_id)
 * - Felhasználónév => átküldése (cmi.core.student_name)
 */

// Credit => credit/no-credit kezelése
// 

/*
 * TODO: amit az LMS is tárol:
 * - Tananyag állapota: passed,completed,failed,incomplete,browsed,not attempted
 * - 
 */

(function ($) {

    // Config
    if (!scormConfig)
        scormConfig = {};
    if (!scormConfig.skillDict)
        scormConfig.skillDict = {};

    var curriculumPublicKey = undefined;
    if (scormConfig.skillDict.curriculumPublicKey)
        curriculumPublicKey = scormConfig.skillDict.curriculumPublicKey;

    if (!scormConfig.playerConfig || !scormConfig.playerConfig.url)
        alert('Config error: player url is not defined.');
    var playerUrl = scormConfig.playerConfig.url;

    // Local scope
    var propertyMap = {
        student_id: 'cmi.core.student_id', // read
        student_name: 'cmi.core.student_name', // read
        lession_location: 'cmi.core.lession_location', // read / write
        credit: 'cmi.core.credit', // read
        lession_status: 'cmi.core.lession_status', // write
        score: 'cmi.core.score.raw', // write
        scoreMax: 'cmi.core.score.max', // write
        scoreMin: 'cmi.core.score.min', // write
        lessonStatus: 'cmi.core.lesson_status' // write
    }
    var $PM$ = propertyMap;
	
    $(function () {
		
        var moodleInit = function () {
            var topPaddingElement = window.parent.document.getElementById('page-mod-scorm-player');
            if (topPaddingElement) topPaddingElement.style.paddingTop = 0;
            var topInfo = window.parent.document.getElementById('scormtop');
            if (topInfo) topInfo.style.display = 'none';
        }

        var messageListenerInit = function () {
            if (window.addEventListener) {
                window.addEventListener("message", onMessage, false);
            }

            function onMessage(event) {
                // Check sender origin to be trusted
                if(playerUrl.startsWith(event.origin) == false) return;

                var data = event.data;

                if (data.func == "doLMSSetValue") {
                    window[data.func].call(null, data.varName, data.varValue);
                }

                else if (data.func == "doLMSGetValue") {
                    window[data.func].call(null, data.varName);
                }

                else if (data.func == "doLMSCommit") {
                    window[data.func].call(null);
                }

                else if (data.func == "doLMSFinish") {
                    window[data.func].call(null);
                }
            }
        }

        var getParameterByName = function (searchInfo, name) {
            if (name == undefined) {
                name = searchInfo;
                searchInfo = window.parent.location.search;
            } else {
                var startPos = searchInfo.indexOf('?');
                searchInfo = searchInfo.substr(startPos, searchInfo.length - startPos);
            }
            name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
            var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(searchInfo);
            return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
        }

        // start
        moodleInit();

        // cross-domain solution
        messageListenerInit();

        // SCORM Info
        // Student
        var studentId = doLMSGetValue($PM$.student_id);
        var studentName = doLMSGetValue($PM$.student_name);
        // Restart?
        var restart = getParameterByName('newattempt') == 'on';
        // Set default
        doLMSSetValue($PM$.scoreMax, 100);
        doLMSSetValue($PM$.scoreMin, 0);
        var defaultLessonStatus = 'not attempted';
        var currentLessonStatus = doLMSGetValue($PM$.lessonStatus);
        if (!currentLessonStatus)
            doLMSSetValue($PM$.lessonStatus, defaultLessonStatus);

        // Commit
        doLMSCommit();
		

		// Start...
        const key = CryptoJS.enc.Utf8.parse(scormConfig.skillDict.key);
        const iv = CryptoJS.enc.Utf8.parse(scormConfig.skillDict.iv);

        const jsonData = {
            username: studentId,
            restart: restart,
			curriculumPublicKey: curriculumPublicKey,
			creationDate: new Date(),
			calledFromLMS: false
        };

        if (studentName)
            jsonData.userfullname = encodeURI(studentName);

        const message = JSON.stringify(jsonData);

        var encryptedText = CryptoJS.AES.encrypt(CryptoJS.enc.Utf8.parse(message), key,
            {
                keySize: 128 / 8,
                iv: iv,
                mode: CryptoJS.mode.CBC,
                padding: CryptoJS.pad.Pkcs7
            });

		encryptedText = encodeURIComponent(encryptedText);

		console.log('encrypted encoded url:' +  playerUrl + '?secretdata=' + encryptedText);

        $('#framewindow').attr('src', playerUrl + '?secretdata=' + encryptedText);
    });

})(jQuery);